#ifdef PI_SUPPORT

/*
const int colortex2Format = RGBA16F; // normals, light & ao
const int colortex3Format = RGBA16F; // PBR Materials
const int colortex12Format = RGBA16F; //Reflections
*/
#else

/*
const int colortex2Format = RGBA16; // normals, light & ao
const int colortex3Format = R16; // PBR Materials
const int colortex12Format = RGBA16; //Reflections
*/

#endif

/*
const int colortex0Format = R11F_G11F_B10F; // Solid
const int colortex1Format = RGBA16F; //translucent
const int colortex4Format = RGBA16F; //prevframe
const int colortex5Format = RGBA8; //water/entity mask
const int colortex10Format = R11F_G11F_B10F; //DH
const int colortex6Format = RGBA16F; //sky
const int colortex7Format = RGB16F; //waternormals
const int colortex8Format = RGBA16F; //sky
const int colortex9Format = RGBA16F; //Reflections
*/

#ifdef DISTANT_HORIZONS
/*
const int colortex13Format = RGB16;
*/
#else
/*                               \
const int colortex13Format = RG16; \
*/
#endif

/*
const bool colortex4Clear = false;
const bool colortex5Clear = true;
const bool colortex6Clear = true;
const bool colortex8Clear = false;
const bool colortex9Clear = false;
const bool colortex13Clear = false;
*/

const vec4 colortex1ClearColor = vec4(0, 0, 0, 0);

varying vec2 texcoord;

// #include "/lib/textrendering.glsl"

//
#define SHARPENING_AMOUNT 1.0 //[0.0 0.025 0.05 0.075 0.1 0.125 0.15 0.20 0.25 0.30 0.50 0.75 1.0 2.0 3.0 4.0 5.0]

//------------------------------------------------------------------------------------------------------------------------------

vec4 sharp(sampler2D s, vec2 uv)
{
    float strength = SHARPENING_AMOUNT; //  effect strength
    vec2 r = 1.0 / viewResolution;      //    1/texture_resolution
    float s_ = strength, s1 = s_ + 1.0, s2 = s_ * 0.2;
    vec4 c0 = texture(s, uv),
         c1 = texture(s, uv - vec2(r.x, 0.0)),
         c2 = texture(s, uv + vec2(r.x, 0.0)),
         c3 = texture(s, uv - vec2(0.0, r.y)),
         c4 = texture(s, uv + vec2(0.0, r.y));
    vec4 avg = (c0 + c1 + c2 + c3 + c4) * s2,
         mn = min(c0, min(c1, min(c2, min(c3, c4)))),
         mx = max(c0, max(c1, max(c2, max(c3, c4))));
    return clamp(mn, c0 * s1 - avg, mx);
}

//------------------------------------------------------------------------------------------------------------------------------

vec3 adjustVibrance(vec3 c, float v)
{
    v = (v + 100.0) * 0.01;
    float r = c.r, g = c.g, b = c.b;
    float mx = max(r, max(g, b)), mn = min(r, min(g, b));
    float avg = (r + g + b) * 0.333333;
    float base = (mx > 0.0 ? (1.0 - (mx - avg) / mx) : 0.0) * (v - 1.0);
    return mix(c, vec3(mx), base * (1.0 - smoothstep(0.0, 0.5, mx - mn)));
}

vec3 adjustSaturation(vec3 c, float s)
{
    s = (s + 100.0) * 0.01;
    float l = c.r * 0.2126 + c.g * 0.7152 + c.b * 0.0722;
    return mix(vec3(l), c, s);
}

// Function to compute the RGB to XYZ matrix
mat3 computeRGBtoXYZMatrix(vec2 red, vec2 green, vec2 blue, vec2 whitePoint)
{
    // Compute XYZ values for each primary
    vec3 X = vec3(red.x / red.y, green.x / green.y, blue.x / blue.y);
    vec3 Y = vec3(1.0, 1.0, 1.0);
    vec3 Z = vec3((1.0 - red.x - red.y) / red.y,
                  (1.0 - green.x - green.y) / green.y,
                  (1.0 - blue.x - blue.y) / blue.y);

    // Assemble the RGB to XYZ matrix (columns are the XYZ values of the primaries)
    mat3 M = mat3(
        vec3(X.r, Y.r, Z.r), // Column 0 (Red)
        vec3(X.g, Y.g, Z.g), // Column 1 (Green)
        vec3(X.b, Y.b, Z.b)  // Column 2 (Blue)
    );

    // Compute the white point in XYZ
    vec3 whiteXYZ = vec3(whitePoint.x / whitePoint.y, 1.0, (1.0 - whitePoint.x - whitePoint.y) / whitePoint.y);

    // Solve for the scaling factors
    vec3 S = inverse(M) * whiteXYZ;

    // Scale the columns of M by S
    M[0] *= S.r; // Multiply first column by Sr
    M[1] *= S.g; // Multiply second column by Sg
    M[2] *= S.b; // Multiply third column by Sb

    return M;
}

float averagePanelLuminance = maxFrameLuminance;
float gameLuma = 100;
float outputMax = maxLuminance;
float outputMin = minLuminance;

vec3 tonemap(vec3 color)
{

    // Tonemapping constants

    const float vibrance = VIBRANCE;
    const float saturation = SATURATION;

    const float exposure = EXPOSURE;
    const float Contrast = CONTRAST;
    const float Shoulder = SHOULDER;
    const float HdrMax = HDR_MAX;
    const float MidIn = MID_IN;
    const float MidOut = MID_OUT;

    // Apply exposure to the inp color
    color *= exposure;
    // Precompute parts of the tonemapping equation
    float A = pow(MidIn, Contrast);
    float D = pow(HdrMax, Contrast);
    float B = pow(HdrMax, Contrast * Shoulder);
    float C = pow(MidIn, Contrast * Shoulder);
    float b = (-A + D * MidOut) / ((B - C) * MidOut);
    float c = (B * A - D * C * MidOut) / ((B - C) * MidOut);

    // Apply the tonemapping curve
    color = pow(color, vec3(Contrast)) / (pow(color, vec3(Contrast * Shoulder)) * b + c);
    color = adjustVibrance(color, 1.0 - vibrance);
    color = adjustSaturation(color, saturation);
    color = clamp(color, 0.0, 10000.0);

    color = LinearTosRGB(color);

    return color;
}

//==============================================================

//==============================================================

#define Purkinje_strength 2.0
#define Purkinje_R 0.2
#define Purkinje_G 0.5
#define Purkinje_B 1.0
#define Purkinje_Multiplier 4.0

////

///

vec3 agxAscCdl(vec3 color, vec3 slope, vec3 offset, vec3 power, float sat)
{
    const vec3 lw = vec3(0.2126, 0.7152, 0.0722);
    float luma = dot(color, lw);
    vec3 c = pow(color * slope + offset, power);
    return luma + sat * (c - luma);
}

// Sample usage
vec3 tonemap_HDR(vec3 color)
{

    const mat3 LINEAR_REC2020_TO_LINEAR_SRGB = mat3(
        1.6605, -0.1246, -0.0182,
        -0.5876, 1.1329, -0.1006,
        -0.0728, -0.0083, 1.1187);

    const mat3 LINEAR_SRGB_TO_LINEAR_REC2020 = mat3(
        0.6274, 0.0691, 0.0164,
        0.3293, 0.9195, 0.0880,
        0.0433, 0.0113, 0.8956);

    // Converted to column major from blender: https://github.com/blender/blender/blob/fc08f7491e7eba994d86b610e5ec757f9c62ac81/release/datafiles/colormanagement/config.ocio#L358
    const mat3 AgXInsetMatrix = mat3(
        0.856627153315983, 0.137318972929847, 0.11189821299995,
        0.0951212405381588, 0.761241990602591, 0.0767994186031903,
        0.0482516061458583, 0.101439036467562, 0.811302368396859);

    // Converted to column major and inverted from https://github.com/EaryChow/AgX_LUT_Gen/blob/ab7415eca3cbeb14fd55deb1de6d7b2d699a1bb9/AgXBaseRec2020.py#L25
    // https://github.com/google/filament/blob/bac8e58ee7009db4d348875d274daf4dd78a3bd1/filament/src/ToneMapper.cpp#L273-L278
    const mat3 AgXOutsetMatrix = mat3(
        1.1271005818144368, -0.1413297634984383, -0.14132976349843826,
        -0.11060664309660323, 1.157823702216272, -0.11060664309660294,
        -0.016493938717834573, -0.016493938717834257, 1.2519364065950405);

    const float AgxMinEv = -12.47393;
    const float AgxMaxEv = 4.026069;

    // color = LINEAR_SRGB_TO_LINEAR_REC2020 * color;

    color /= gameLuma;
    // color /= 1 + color;

    // 1. agx()
    // Input transform (inset)
    color = AgXInsetMatrix * color;

    color = max(color, 1e-10); // From Filament: avoid 0 or negative numbers for log2

    // Log2 space encoding
    color = clamp(log2(color), AgxMinEv, AgxMaxEv);
    color = (color - AgxMinEv) / (AgxMaxEv - AgxMinEv);

    color = clamp(color, 0.0, 1.0); // From Filament

    // Apply sigmoid function approximation
    // Mean error^2: 3.6705141e-06
    vec3 x2 = color * color;
    vec3 x4 = x2 * x2;
    color = +15.5 * x4 * x2 - 40.14 * x4 * color + 31.96 * x4 - 6.868 * x2 * color + 0.4298 * x2 + 0.1191 * color - 0.00232;

    // 2. agxLook()
    color = agxAscCdl(color, vec3(0.99), vec3(0.025), vec3(1.1), 1.15);

    // 3. agxEotf()
    // Inverse input transform (outset)
    color = AgXOutsetMatrix * color;

    // sRGB IEC 61966-2-1 2.2 Exponent Reference EOTF Display
    color = pow(max(vec3(0.0), color), vec3(2.2)); // From filament: max()

    // Scale the color back to the outputMax range
    color *= outputMax;

    // Adjust for minimum display luminance
    color = outputMin + color * ((outputMax - outputMin) / outputMax);

    // Optionally, ensure the output color is within the displayable range
    color = clamp(color, 0.0, outputMax);

    // Normalize so that 80 nits correspond to 1.0
    color /= 80.0;

    // Compute sRGB to XYZ matrix
    mat3 sRGBToXYZ = computeRGBtoXYZMatrix(vec2(0.708, 0.292), vec2(0.170, 0.797), vec2(0.131, 0.046), vec2(0.3127, 0.3290));

    // Compute target RGB to XYZ matrix
    mat3 targetRGBToXYZ = computeRGBtoXYZMatrix(redPrimary, greenPrimary, bluePrimary, whitePoint);

    // Compute the XYZ to target RGB matrix (inverse of targetRGBToXYZ)
    mat3 XYZToTargetRGB = inverse(targetRGBToXYZ);

    // Compute the combined sRGB to target RGB transformation matrix
    mat3 sRGBToTargetRGB = XYZToTargetRGB * sRGBToXYZ;

    // Apply the color space transformation
    color = sRGBToTargetRGB * color;

    return color;
}
vec3 agx_SDR(vec3 color)
{

    const mat3 LINEAR_REC2020_TO_LINEAR_SRGB = mat3(
        1.6605, -0.1246, -0.0182,
        -0.5876, 1.1329, -0.1006,
        -0.0728, -0.0083, 1.1187);

    const mat3 LINEAR_SRGB_TO_LINEAR_REC2020 = mat3(
        0.6274, 0.0691, 0.0164,
        0.3293, 0.9195, 0.0880,
        0.0433, 0.0113, 0.8956);

    // Converted to column major from blender: https://github.com/blender/blender/blob/fc08f7491e7eba994d86b610e5ec757f9c62ac81/release/datafiles/colormanagement/config.ocio#L358
    const mat3 AgXInsetMatrix = mat3(
        0.856627153315983, 0.137318972929847, 0.11189821299995,
        0.0951212405381588, 0.761241990602591, 0.0767994186031903,
        0.0482516061458583, 0.101439036467562, 0.811302368396859);

    // Converted to column major and inverted from https://github.com/EaryChow/AgX_LUT_Gen/blob/ab7415eca3cbeb14fd55deb1de6d7b2d699a1bb9/AgXBaseRec2020.py#L25
    // https://github.com/google/filament/blob/bac8e58ee7009db4d348875d274daf4dd78a3bd1/filament/src/ToneMapper.cpp#L273-L278
    const mat3 AgXOutsetMatrix = mat3(
        1.1271005818144368, -0.1413297634984383, -0.14132976349843826,
        -0.11060664309660323, 1.157823702216272, -0.11060664309660294,
        -0.016493938717834573, -0.016493938717834257, 1.2519364065950405);

    const float AgxMinEv = -12.47393;
    const float AgxMaxEv = 4.026069;

    color = LINEAR_SRGB_TO_LINEAR_REC2020 * color;

    // 1. agx()
    // Input transform (inset)
    color = AgXInsetMatrix * color;

    color = max(color, 1e-10); // From Filament: avoid 0 or negative numbers for log2

    // Log2 space encoding
    color = clamp(log2(color), AgxMinEv, AgxMaxEv);
    color = (color - AgxMinEv) / (AgxMaxEv - AgxMinEv);

    color = clamp(color, 0.0, 1.0); // From Filament

    // Apply sigmoid function approximation
    // Mean error^2: 3.6705141e-06
    vec3 x2 = color * color;
    vec3 x4 = x2 * x2;
    color = +15.5 * x4 * x2 - 40.14 * x4 * color + 31.96 * x4 - 6.868 * x2 * color + 0.4298 * x2 + 0.1191 * color - 0.00232;

    // 2. agxLook()
    color = agxAscCdl(color, vec3(0.97), vec3(0.025), vec3(1.1), 1.25);

    // 3. agxEotf()
    // Inverse input transform (outset)
    color = AgXOutsetMatrix * color;

    // Optionally, ensure the output color is within the displayable range
    color = clamp(color, 0.0, 1.0);

    color = LINEAR_REC2020_TO_LINEAR_SRGB * color;

    return color;
}
//////

vec3 doMotionBlur(sampler2D colorTexture, vec2 uv, float depth, inout vec3 colorSum)
{
    const int sampleCount = 4;
    const float maxBlurStrength = 0.05;

    if (depth < 0.56)
        return colorSum;

    // Convert current texcoord and depth to world space
    vec3 currentPos = toScreenSpace(vec3(uv, depth));
    currentPos = toWorldSpace(currentPos) + (cameraPosition - previousCameraPosition);

    // Project to previous frame's clip space
    vec3 previousPos = mat3(gbufferPreviousModelView) * currentPos + gbufferPreviousModelView[3].xyz;
    previousPos = toClipSpace3(previousPos);

    // Calculate motion vector
    vec2 motionVec = uv - previousPos.xy;
    float motionLength = length(motionVec);
    motionVec = (motionVec / (1.0 + motionLength)) * maxBlurStrength;

    // Early out if there's barely any motion
    if (motionLength < 1e-4)
        return colorSum;

    // Move to starting point of blur trail
    vec2 baseUV = uv - motionVec * (float(sampleCount) * 0.5);
    vec2 texelClamp = 2.0 / vec2(viewWidth, viewHeight);

    vec3 blurSum = vec3(0.0);
    for (int i = 0; i < sampleCount; i++)
    {
        vec2 sampleUV = baseUV + motionVec * float(i);
        sampleUV = clamp(sampleUV, texelClamp, 1.0 - texelClamp);
        blurSum += texture2D(colorTexture, sampleUV).rgb;
    }

    blurSum /= float(sampleCount);

    // Blend original color and blurred color based on motion strength
    float blurAmount = clamp(motionLength * 20.0, 0.0, 1.0); // You can tweak the 20.0 to control fade-in speed
    return mix(colorSum, blurSum, blurAmount);
}

void main()
{

#ifdef DOF
    vec3 color = sharp(colortex0, texcoord).rgb;
    #ifdef MOTION_BLUR
    color = doMotionBlur(colortex0, texcoord, texture2D(depthtex0, texcoord).r, color);
    #endif

#else
    vec3 color = sharp(colortex4, texcoord).rgb;
    #ifdef MOTION_BLUR
    color = doMotionBlur(colortex4, texcoord, texture2D(depthtex0, texcoord).r, color);
    #endif
#endif

#ifdef BLOOM

    #ifdef NETHER
    vec3 sum = textureLod(colortex6, texcoord, 0).rgb * 4.0;
    color += sum;
    #else
    vec3 sum = texture(colortex6, texcoord).rgb;
    sum += textureLod(colortex6, texcoord, 0).rgb * 0.5;
    color += sum;
    #endif

#endif

#ifdef SHADOW_DEBUG

    color = texture(shadowcolor0, texcoord).rgb;
#endif

#ifdef HDR_OUTPUT
    color = tonemap_HDR(color);
#else
    // color = agx_SDR(color);
    color = tonemap(color);
#endif
    float lumPhotopic = dot(color, vec3(0.2126, 0.7152, 0.0722)); // True perceptual luminance (cones)
    float lumScotopic = dot(color, vec3(0.85, 0.7, 0.45)) * 64.0; // Reduced gain to avoid overpowering in HDR

    // Rod-cone interpolation curve
    float rodMix = mix(1.0, lumScotopic / (1.0 + lumScotopic), 1.0 / (1.0 + Purkinje_strength));

    // Build scotopic color (cool hue boost under darkness)
    vec3 scotopicTint = vec3(Purkinje_R, Purkinje_G, Purkinje_B);
    vec3 scotopicColor = pow(clamp(lumPhotopic, 0.0, 1.0), 0.6) * Purkinje_Multiplier * scotopicTint + 0.001;

    // Blend between scotopic and original color
    color = mix(scotopicColor, color, rodMix);

    // Optional night vision bloom / visibility boost (tunable for HDR)
    float nightLuma = clamp(lumPhotopic / 1.5, 0.0, 1.0); // Avoid clamping full HDR
    vec3 nightBoost = vec3(1.0) * pow(nightLuma, 0.4) * 0.75 + 0.05;
    color = mix(nightBoost, color, 1.0 - nightVision * 0.1);

    gl_FragData[0] = vec4(color, 1.);
    // gl_FragData[0] = vec4(atmosphereUp,1);
}